# -------------------------------------------------------- 
# SharePoint 2013 Advanced WCM - Sample Code 
# by John Chapman
# (c) Packt Publishing
#
# Apply a master page to a device channel
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# VARIABLES
# Replace the variable values appropriately
# -------------------------------------------------------- 

# URL to the SharePoint site collection
$siteUrl = "http://sharepoint/sitecollection"

# Device channle name
$channelName = "PowerShell"

# Relative URL to master page
$masterUrl = "/_catalogs/masterpage/oslo.master"

# -------------------------------------------------------- 
# END VARIABLES
# -------------------------------------------------------- 

# -------------------------------------------------------- 
# SCRIPT
# -------------------------------------------------------- 

# Add the SharePoint PowerShell snap-in
Add-PSSnapin Microsoft.SharePoint.PowerShell -ErrorAction SilentlyContinue

# Load the required SharePoint assemblies
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.Publishing.dll")
[Reflection.Assembly]::LoadFrom("C:\Program Files\Common Files\microsoft shared\Web Server Extensions\15\ISAPI\Microsoft.SharePoint.dll")

# Get the types needed to construct the device channel mapping file object
$typeWeb = [Microsoft.SharePoint.SPWeb]
$typeBool = [System.Boolean]
$typeMappingFile = [System.Type]::GetType("Microsoft.SharePoint.Publishing.Mobile.MasterPageMappingsFile, Microsoft.SharePoint.Publishing, Version=15.0.0.0, Culture=neutral, PublicKeyToken=71e9bce111e9429c")
$consMappingFileParams = ($typeWeb, $typeBool, $typeWeb)

# Get the mapping file constructor
$consMappingFile = $typeMappingFile.GetConstructor($consMappingFileParams)

# Get the properties and construct the mapping file object
$mappingFileParams = [System.Array]::CreateInstance([System.Object], 3)
$mappingFileParams[0] = (Get-SPSite $siteUrl).RootWeb
$mappingFileParams[1] = $false
$mappingFileParams[2] = $null
$mappingFile = $consMappingFile.Invoke($mappingFileParams)

# Set the master page URL for the device channel and update the device channel
$mappingFile[$channelName].MasterPageUrl = $masterUrl
$mappingFile.UpdateSingleChannel($channelName) 

# -------------------------------------------------------- 
# END SCRIPT
# -------------------------------------------------------- 